#include "OSXSpecifics.h"

/* OSXSpecifics.c
	
	This file and its header represent a one-stop shop for setting up OSX specific things.
	The goal is to only need to call the setup procedure once, and have the function pointers
	available for the rest of the time Frontier is running. I'll hone this down over time,
	but for right now, this is good enough.
	
*/


//		if (strcmp((char*)*par->params[0], "true")==0) useQDText(1);
//		else useQDText(0);



static OSStatus LoadFrameworkBundle(CFStringRef framework, CFBundleRef *bundlePtr)
{
	OSStatus 	err;
	FSRef 		frameworksFolderRef;
	CFURLRef	baseURL;
	CFURLRef	bundleURL;
	
	if ( bundlePtr == nil )	return( -1 );
	
	*bundlePtr = nil;
	
	baseURL = nil;
	bundleURL = nil;
	
	err = FSFindFolder(kOnAppropriateDisk, kFrameworksFolderType, true, &frameworksFolderRef);
	if (err == noErr) {
		baseURL = CFURLCreateFromFSRef(kCFAllocatorSystemDefault, &frameworksFolderRef);
		if (baseURL == nil) {
			err = coreFoundationUnknownErr;
		}
	}
	if (err == noErr) {
		bundleURL = CFURLCreateCopyAppendingPathComponent(kCFAllocatorSystemDefault, baseURL, framework, false);
		if (bundleURL == nil) {
			err = coreFoundationUnknownErr;
		}
	}
	if (err == noErr) {
		*bundlePtr = CFBundleCreate(kCFAllocatorSystemDefault, bundleURL);
		if (*bundlePtr == nil) {
			err = coreFoundationUnknownErr;
		}
	}
	if (err == noErr) {
	    if ( ! CFBundleLoadExecutable( *bundlePtr ) ) {
			err = coreFoundationUnknownErr;
	    }
	}

	// Clean up.
	if (err != noErr && *bundlePtr != nil) {
		CFRelease(*bundlePtr);
		*bundlePtr = nil;
	}
	if (bundleURL != nil) {
		CFRelease(bundleURL);
	}	
	if (baseURL != nil) {
		CFRelease(baseURL);
	}	
	
	return err;
}


void useQDText(int i)
{
	OSStatus 			err;
	CFBundleRef 		sysBundle;
	UInt32 				newFlags = 0;
	char				s[64];
	QuartzTextPtr		QuartzText;

	
	s[0]=0;
	err = LoadFrameworkBundle( CFSTR("ApplicationServices.framework"), &sysBundle );
	if (err == noErr) {
		QuartzText = CFBundleGetFunctionPointerForName(sysBundle, CFSTR("SwapQDTextFlags") );
		if (QuartzText != nil) {
			//newFlags = kQDUseCGTextRendering | kQDUseCGTextMetrics;
			if (i == 1) err = QuartzText(kQDUseCGTextRendering);
			else {
				err = QuartzText(0);
				err = 0;
			}
		}
	}
}
